//
//  EquipPackagesManager.h
//  REGA AW109SP
//
//  Created by Vadim on 12/2/14.
//
//

#import <Foundation/Foundation.h>
#import "EquipmentPackages.h"

@interface EquipPackagesManager : NSObject



+ (EquipPackagesManager*)sharedInstance;
+ (void)initializeWithMaxConfigs:(int)numberOfConfigs;
- (void)downloadDefaultConfigsFromURL:(NSString*)downloadURL completionBlock:(void(^)(NSString* error))block;
- (void)exportPackagesToURL:(NSString*)uploadURL completionBlock:(void(^)(NSString* error))block;;
- (void)exportPackageForKey:(NSString*)key toURL:(NSString*)uploadURL completionBlock:(void(^)(NSString* error))block;;
- (EquipmentPackages*)addNewPackageWithKey:(NSString*)key andDefaultConfig:(int)configIndex;
- (EquipmentPackages*)addNewPackageWithKey:(NSString*)key copyingFromPackage:(EquipmentPackages*)package;
- (EquipmentPackages*)packageForKey:(NSString*)key;
- (void)resetPackageForKey:(NSString*)key fromConfig:(int)configIndex;
- (void)reset;

@end
